unit Bdetool2;

(*
With some refinement this form could be a candidate for the
gallery, or for being wrapped in a component. It provides
selecting and arraging of a DataSet's fields for different
purposes, with a built-in grid fields setting (sets Visible
and Index properties of the fields).
*)

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, DB;

type
  TSelFldsFrm = class(TForm)
    OkBtn: TButton;
    CancelBtn: TButton;
    AddBtn: TButton;
    DeleteBtn: TButton;
    ListBox1: TListBox;
    ListBox2: TListBox;
    procedure FormCreate(Sender: TObject);
    procedure SetButtonStatus(Sender: TObject);
    procedure ListBox2DragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure ListBox2DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure AddBtnClick(Sender: TObject);
    procedure DeleteBtnClick(Sender: TObject);
    procedure SetGridFields(ADataSet: TDBDataSet);
    procedure InitGridFields(ADataSet: TDBDataSet);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SetCenterPos;
    procedure SetPrimary;
    procedure SetMoveMode(Value: boolean);
    procedure SetRearrangeMode(Value: boolean);
  private
    { Private-Deklarationen }
    FDoMove: boolean; {if true, items are moved from box1 to box2}
    FAllowRearng: boolean; {if true, field order may be rearranged}
    FIsPrimary: boolean; {if true, only contiguous blocks beginning
                          with field 1 can be selected (Pdox Primary)}
    FShadowList: TStringList; {keeps the original index order for compare}
  public
    { Public-Deklarationen }
  end;

var
  SelFldsFrm: TSelFldsFrm;

implementation

uses BDETool1;

{$R *.DFM}
{$B-}

procedure TSelFldsFrm.FormCreate(Sender: TObject);
begin
  FDoMove := True;
  FAllowRearng := True;
  FIsPrimary := False;
  FShadowList := TStringList.Create;
  CalcControlSize(self);
  SetButtonStatus(Sender);
end;

{center on the application's active form before showing this form:}
procedure TSelFldsFrm.SetCenterPos;
var CFTop, CFLeft: integer;
begin
  with Screen.ActiveForm do
  begin
    CFTop := (Height div 2) - ((self).Height div 2) + Top;
    CFLeft := (Width div 2) - ((self).Width div 2) + Left;
    (self).SetBounds(CFLeft, CFTop, (self).Width, (self).Height);
  end;
end;

procedure TSelFldsFrm.InitGridFields(ADataSet: TDBDataSet);
var i: integer;
begin
  for i:=0 to pred(ADataSet.FieldCount) do
    with ADataSet.Fields[i] do
    begin
      FShadowList.Add(DisplayLabel);
      if (Visible) then
      begin
        ListBox2.Items.Add(DisplayLabel);
        if not FDoMove then
          ListBox1.Items.Add(DisplayLabel);
      end
      else
        ListBox1.Items.Add(DisplayLabel);
    end;
end;

procedure TSelFldsFrm.SetGridFields(ADataSet: TDBDataSet);
var i,j: integer;
begin
  for i:=0 to pred(ADataSet.FieldCount) do
    with ADataSet.Fields[i] do
      Visible := (ListBox2.Items.IndexOf(DisplayLabel) <> -1);
  {some trouble here because I wanted to use DisplayLabel
   instead of FieldName to select the fields}
  {using the first loop for index assignment won't
   work for some indices might be reassigned automatically
   during that process, thus confusing our settings}
  for i:=0 to pred(ListBox2.Items.Count) do
    for j:=0 to pred(ADataSet.FieldCount) do
      with ADataSet.Fields[j] do
        if DisplayLabel = ListBox2.Items[i] then
          Index := ListBox2.Items.IndexOf(DisplayLabel);
end;

procedure TSelFldsFrm.SetButtonStatus(Sender: TObject);
begin
  OkBtn.Enabled := (ListBox2.Items.Count > 0);
  AddBtn.Enabled := (ListBox1.SelCount > 0);
  DeleteBtn.Enabled := (ListBox2.ItemIndex <> -1);
end;

procedure TSelFldsFrm.SetPrimary;
begin
  SetRearrangeMode(False);
  FIsPrimary := True;
end;

procedure TSelFldsFrm.SetMoveMode(Value: boolean);
begin
  FDoMove := Value;
end;

procedure TSelFldsFrm.SetRearrangeMode(Value: boolean);
begin
  Value := Value and (not FIsPrimary);
  FAllowRearng := Value;
  if not FAllowRearng then
    ListBox2.DragMode := dmManual
  else
    ListBox2.DragMode := dmAutomatic;
end;

{thanks to Richard Howard and Lloyd's Help File for this!}
procedure TSelFldsFrm.ListBox2DragDrop(Sender, Source: TObject; X,
  Y: Integer);
var i: integer;
    MoveItem: integer;
begin
  {instructions for moving an item WITHIN ListBox2}
  begin
    MoveItem := ListBox2.ItemIndex;
    {i = the item UNDER the moving, selected item}
    i := ListBox2.ItemAtPos(Point(X, Y), True);
    ListBox2.Items.Move(MoveItem, i); {puts the moved item into place}
    ListBox2.ItemIndex := i; {select (highlight) the item you moved}
    if i = -1 then ListBox2.ItemIndex := ListBox2.Items.Count-1;
  end;
end;

procedure TSelFldsFrm.ListBox2DragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  Accept := True;
end;

procedure TSelFldsFrm.AddBtnClick(Sender: TObject);
var i,j: integer;
begin
  with ListBox1 do
    if (SelCount > 0) then
      for i:=pred(Items.Count) downto 0 do
        if Selected[i]
        and (ListBox2.Items.IndexOf(Items[i]) = -1) then
        begin
          if not FAllowRearng then
          begin
            if FIsPrimary then
            begin
              if (ListBox2.Items.Count = Items.IndexOf(Items[i])) then
                ListBox2.Items.Insert(i,Items[i])
            end
            else
              for j:=0 to pred(ListBox2.Items.Count) do
                if (FShadowList.IndexOf(ListBox2.Items[j]) >
                FShadowList.IndexOf(Items[i])) then
                begin
                  ListBox2.Items.Insert(j,Items[i]);
                  break;
                end
                else
                  if (j = pred(ListBox2.Items.Count)) then
                    ListBox2.Items.Add(Items[i]);
          end
          else
            ListBox2.Items.Add(Items[i]);

          if FDoMove then
            Items.Delete(i);
        end;
  SetButtonStatus(Sender);
end;

procedure TSelFldsFrm.DeleteBtnClick(Sender: TObject);
var i: integer;
begin
  with ListBox2 do
    if not FIsPrimary then
    begin
      if FDoMove then
        ListBox1.Items.Add(Items[ItemIndex]);
      Items.Delete(ItemIndex);
    end
    else {remove all fields with a higher index, too}
      for i := pred(Items.Count) downto ItemIndex do
      begin
        if FDoMove then
          ListBox1.Items.Add(Items[i]);
        Items.Delete(i);
      end;
  SetButtonStatus(Sender);
end;

procedure TSelFldsFrm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  FShadowList.Free;
end;

end.
